
#ifndef NIKONSDK
#define NIKONSDK

#include "Maid3.h"
#include "Maid3d1.h"
#include "CtrlSample.h"
#include "stiso.h"
#include "stcomplist.h"

extern unsigned char* buffer;
extern long size;
extern int transfered;
extern int Live;

//unsigned nafvalue[3];

class NikonCamera {
private:
	// prts Model,Src,Item,Data
	LPRefObj    _NikonpRefMod;
	LPRefObj    _NikonpRefSrc;
	LPRefObj    _NikonpRefItm;
	LPRefObj    _NikonpRefDat;
	unsigned char* livebuffer;
	long    livesize;
	void TakePicture();
	char CameraName[80];
	//stisolist* rootlist=NULL;

	struct stisolist isolist[50];
	int nofiso;
	int isoindex;
	struct stcomplist compression[50];
	int nofcompression;
	int compindex;
	int imagesizeindex;
	int nofimagesize;
	int results;
	int nofwb;
	int wbindex;



		int nofafmode;
	int afindex;
		int nofafarea;
	int afareaindex;





	public:
		int CameraCount;
		NikonCamera();
		~NikonCamera();

		NikonCamera* getptr(){
			return this;
		}

				//void GetAFModes();
		int GetNofAFMode(){
			return nofafmode;
		}
		int GetAFIndex(){
			return afindex;
		}

		int GetAFAreaIndex(){
			return afareaindex;
		}

		void GetAFModes();
		void SetAFMode(int index);
		//void SetAFMode(int index);
        		void GetAFArea();
		void SetAFArea(int index);

		void GetIso();

		virtual stisolist* GetIsoList(){
			return isolist;
		}
		void TakePictureToFile();
		void TakePictureToStream();
		void TakePictureAsync();
		void DownLoadImageToFile();

		void LiveViewOn();
		void LiveViewOff();
		void DownLoadEVFData();
		int GetResult(){
			return results;
		}

// CompressionLevel

				void    GetCompressionLevel();
		void    SetCompressionLevel(int index);
	virtual stcomplist* GetCompList(){
		return compression;
	}
		int GetNofCompressionLevel(){
			return nofcompression;
		}
		int  GetCompressionLevelIndex()
		{
			return compindex;
		}
//WBMode

	void    GetWBMode();
	void    SetWBMode(int index);

	int     GetNofWB(){
		return nofwb;
	}
	int GetWBIndex(){
		return wbindex;
	}


		int GetNofIso(){
			return nofiso;
		}
		int GetIsoIndex(){
			return isoindex;
		}
		void SetIso(int index);
		void RecordMovie();
		void StopMovie();
		virtual char* GetName(){
			return CameraName;
		}

		long getsize(){
				return size;
		}
		unsigned char* getbuffer(){
				return buffer;
		}
		int IsTransfered(){
			return transfered;
		}
		void UnsetTransfered(){
			transfered=0;
		}
        void DoAF();
		long	getlivesize(){
			return livesize;
		}
		unsigned char* getlivebuffer() {
            return livebuffer;
		}

		int GetNofImageSize(){
			return nofimagesize;
		}
		void GetImageSizeList();
		void SetImageSize(int index);
		int GetImageSizeIndex(){
			return imagesizeindex;
		}
        int GetBatteryLevel();


};












#endif

