
#ifndef CPPEDSDKLIB
#define CPPEDSDKLIB

#include "EDSDK.h"
#include "EDSDKTypes.h"
#include "EDSDKErrors.h"
#include "stiso.h"
#include "stcomplist.h"


extern		  unsigned char* buffer;
extern		  long size;




class CanonCamera {

	  private:
		EdsCameraRef    cameraRef;
			  EdsCameraListRef cameraList;
		  EdsError	err;
	      //int	count;	// camera count
	      EdsUInt32	count;
		  EdsDeviceInfo deviceInfo;
		  char CameraName[80];
		  bool sx70hs;
		  unsigned char* livebuffer;
		  long  livesize;
          	struct stisolist isolist[50];
	int nofiso;
	int isoindex;
	int nofafmode;
	int afindex;

	EdsPropertyDesc IsoDesc;
    EdsPropertyDesc AFDesc;
	EdsPropertyDesc ImageQuality;
	EdsPropertyDesc WhiteBalance;
	int nofwb;
	int wbindex;
	int results;

		struct stcomplist compression[50];
	int nofcompression;
	int compindex;




	public:
    int   CameraCount;
		  CanonCamera();
		  ~CanonCamera(){
				EdsTerminateSDK();
			}
		  int GetResult(){
			return results;
		  }
	CanonCamera* getptr(){
			return this;
		}

        				void    GetCompressionLevel();
		void    SetCompressionLevel(int index);
	virtual stcomplist* GetCompList(){
		return compression;
    }
		int GetNofCompressionLevel(){
			return nofcompression;
		}
		int  GetCompressionLevelIndex()
		{
			return compindex;
		}
 //
		virtual stisolist* GetIsoList(){
			return isolist;
		}

 		int GetNofIso(){
			return nofiso;
		}
		int GetIsoIndex(){
			return isoindex;
		}
        		void GetIso();
		void SetIso(int index);

 //

		void GetAFModes();
		int GetNofAFMode(){
			return nofafmode;
		}
		int GetAFIndex(){
			return afindex;
		}

		//void GetAFMode();
		void SetAFMode(int index);

		int GetNofWB(){
			return nofwb;
		}
		int GetWBIndex(){
			return wbindex;
		}

        void SetWB(int index);

		void GetWBList();

			void TakePictureToStream();
			void RecordMovie();
			void StopMovie();
		   	virtual char* GetName(){
				return CameraName;
            }
			long getsize(){
				return size;
			}
			unsigned char* getbuffer(){
				return buffer;
			}
            		long	getlivesize(){
			return livesize;
		}
		unsigned char* getlivebuffer() {
            return livebuffer;
		}
        void DoAF();
			void LiveViewOn(void);
			void LiveViewOff(void);
			void LiveViewOnTFT(void);
            void LiveViewOffTFT(void);
			void DownLoadEVFData(void);
			int  IsTransfered(void);
			void TakePictureToFile();
			void Rehook(void);
            int GetBatteryLevel();

			friend void downloadImage(EdsDirectoryItemRef directoryItem);

};

#endif
